local SourceType, TargetType;

function PS_CombatLog(Event, SourceName, SourceFlag, TargetName, TargetFlag, arg9, arg10, arg11, arg12, arg13)
  if (PSvars.Addons == "OFF" or not PS_SentryCheck) then
    return;
  elseif (PSvars.Addons == "BG" and not PS_bgmode) then
    return;
  elseif (PSvars.Addons == "NOT ARENA" and IsActiveBattlefieldArena()) then
    return;
  elseif (PSvars.Addons == "NOT BG" and PS_ZoneIsABG(GetRealZoneText())) then
    return;
  elseif (PSvars.Addons == "NOBG" and PS_bgmode) then
    return;
  end
  if PS_ZoneIsABG(GetRealZoneText()) then
    local tempname;
    if SourceName ~= nil then
      for tempname in string.gmatch(SourceName, "(.*)%-.*") do
        SourceName = tempname;
      end
    end
    if TargetName ~= nil then
      for tempname in string.gmatch(TargetName, "(.*)%-.*") do
        TargetName = tempname;
      end
    end

  end
  if Event == "UNIT_DIED" then
    PS_DeathDetect(TargetName);
    return;
  end
  if Event == "PARTY_KILL" then
    PS_DeathDetect(TargetName);
    return;
  end

  if (PSvars.SentryMode and PS_SentryCheck) then
    if (SourceName ~= nil and TargetName ~= nil) then
      if (PS_PlayerHostile(SourceFlag) and PS_PlayerFriend(TargetFlag)) or (PS_PlayerFriend(SourceFlag) and PS_PlayerHostile(TargetFlag)) then
        if Event == "SPELL_CAST_SUCCESS" then
          PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10);
          return;
        end
        if Event == "SPELL_INTERRUPT" then
          PS_UnitParse(SourceName, SourceFlag, nil, nil, arg10);
          PS_UnitParse(TargetName, TargetFlag, nil, nil, arg13);
          return;
        end
        if Event == "RANGE_DAMAGE" then
          if TargetName == UnitName("player") then
            PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10, arg12);
          else
            PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10);
          end
          return;
        end
        if Event == "SPELL_PERIODIC_DAMAGE" then
          if TargetName == UnitName("player") then
            PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10, arg12);
          else
            PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10);
          end
          return;
        end
        if Event == "SPELL_PERIODIC_MISSED" then
          PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10);
          return;
        end
      end
    end
    local zonetext = GetRealZoneText();
    if PS_ZoneIsABG(zonetext) then
      if Event == "SPELL_CAST_START" then
        PS_UnitParse(SourceName, SourceFlag, nil, nil, arg10);
        return;
      end
      if Event == "SPELL_HEAL" then
        PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10, arg12, "HEAL");
        return;
      end
      if Event == "SPELL_PERIODIC_HEAL" then
        PS_UnitParse(SourceName, SourceFlag, TargetName, TargetFlag, arg10, arg12, "HEAL");
        return;
      end
      if Event == "ENVIRONMENTAL_DAMAGE" then
        PS_UnitParse(TargetName, TargetFlag);
        return;
      end
    end

  end

end

function PS_UnitParse(SourceNameUP, SourceFlagUP, TargetNameUP, TargetFlagUP, SpellNameUP, DamageUP, TypeUP)
  if (SourceNameUP ~= nil and TargetNameUP == nil) then
    if PS_UnitHostile(SourceFlagUP) then
      SourceType, SpellNameUP = PS_UnitNPC(SourceFlagUP, SpellNameUP);
      PS_CaptureAttack(SourceNameUP, nil, nil, nil, SourceType, nil, SpellNameUP);
    end
  elseif (SourceNameUP == nil and TargetNameUP ~= nil) then
    if PS_UnitHostile(TargetFlagUP) then
      TargetType = PS_UnitNPC(TargetFlagUP);
      PS_CaptureAttack(TargetNameUP, nil, nil, nil, TargetType);
    end
  elseif (SourceNameUP == TargetNameUP) then
    if PS_UnitHostile(SourceFlagUP) then
      SourceType, SpellNameUP = PS_UnitNPC(SourceFlagUP, SpellNameUP);
      PS_CaptureAttack(SourceNameUP, nil, nil, nil, SourceType, nil, SpellNameUP);
    end
  else
    SourceType, SpellNameUP = PS_UnitNPC(SourceFlagUP, SpellNameUP);
    TargetType = PS_UnitNPC(TargetFlagUP);
    if PS_UnitHostile(SourceFlagUP) then
      if PS_UnitHostile(TargetFlagUP) then
        if TypeUP == "HEAL" then
          PS_CaptureAttack(SourceNameUP, TargetNameUP, DamageUP, nil, SourceType, 1, SpellNameUP);
          PS_CaptureAttack(TargetNameUP, nil, nil, nil, SourceType, 2);
        end
        PS_CaptureAttack(SourceNameUP, nil, nil, nil, SourceType, nil, SpellNameUP);
        PS_CaptureAttack(TargetNameUP, nil, nil, nil, SourceType);
      else
        PS_CaptureAttack(SourceNameUP, TargetNameUP, DamageUP, nil, SourceType, nil, SpellNameUP);
      end
    else
      if PS_UnitHostile(TargetFlagUP) then
        PS_CaptureAttack(TargetNameUP, nil, nil, nil, SourceType);
      end
    end
  end
end

function PS_PlayerFriend(flag)
  if bit.band(bit.band(flag, 0x00000010), 0x000000F0) > 0 and bit.band(bit.band(flag, 0x00000100), 0x00000F00) > 0 then
    return true;
  else
    return false;
  end
end

function PS_PlayerHostile(flag)
  if bit.band(bit.band(flag, 0x00000040), 0x000000F0) > 0 and bit.band(bit.band(flag, 0x00000100), 0x00000F00) > 0 then
    return true;
  else
    return false;
  end
end

function PS_UnitHostile(flag)
  if bit.band(bit.band(flag, 0x00000040), 0x000000F0) > 0 then
    return true;
  else
    return false;
  end
end

function PS_UnitNPC(flag, spell)
  if bit.band(bit.band(flag, 0x00000400), 0x0000FC00) > 0 then
    return nil, spell;
  elseif bit.band(bit.band(flag, 0x00001000), 0x0000FC00) > 0 then
    return 3, nil;
  else
    return 99, nil;
  end
end
